﻿using Microsoft.Practices.Prism.Mvvm;
using Microsoft.Practices.Prism.PubSubEvents;
using Microsoft.Practices.Prism.Regions;
using ModuleA.Models;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;

namespace ModuleA.ViewModels
{
    public class CatalogViewModel : BindableBase, INavigationAware
    {
		private ObservableCollection<Product> products;
        IEventAggregator _eventAggregator;

        public ObservableCollection<Product> Products
		{
			get
			{
				return products;
			}
			protected set
			{
				SetProperty<ObservableCollection<Product>>(ref products, value);
			}
		}

        protected IProductRepository productsRepository;

        public CatalogViewModel(IProductRepository productsRepository, EventAggregator eventAggregator)
        {
            _eventAggregator = eventAggregator;
            _eventAggregator.GetEvent<messageEvent>().Subscribe(komunikat, true);
            this.productsRepository = productsRepository;
            this.Products = new ObservableCollection<Product>(this.productsRepository.GetAll());
        }

        public CatalogViewModel(IProductRepository productsRepository)
        {
           // _eventAggregator = eventAggregator;
           // _eventAggregator.GetEvent<messageEvent>().Subscribe(komunikat, true);
            this.productsRepository = productsRepository;
            this.Products = new ObservableCollection<Product>(this.productsRepository.GetAll());
        }

		public bool IsNavigationTarget(NavigationContext navigationContext)
		{
			return true;
		}

		public void OnNavigatedFrom(NavigationContext navigationContext)
		{
		}

        public void komunikat (string tekst)
        {
            MessageBox.Show("otrzymano wiadomosc od innego wątku: " + tekst);

        }

		public void OnNavigatedTo(NavigationContext navigationContext)
		{
			this.Products = new ObservableCollection<Product>(this.productsRepository.GetAll());
		}
	}
}
